{
  description = "NixOS in MicroVMs";

  # nixConfig = {
  #   extra-substituters = [ "https://microvm.cachix.org" ];
  #   extra-trusted-public-keys = [ "microvm.cachix.org-1:oXnBc6hRE3eX5rSYdRyMYXnfzcCxC7yKPTbZXALsqys=" ];
  # };

  inputs = {
    flake-utils.url = "github:numtide/flake-utils";
    microvm = {
      url = "github:microvm-nix/microvm.nix";
      inputs.nixpkgs.follows = "nixpkgs";
    };
  };

  outputs = { self, nixpkgs, microvm, flake-utils }@precursor:
    flake-utils.lib.eachDefaultSystem (arch:  let
      pkgs = import nixpkgs { system = arch; };
      params = precursor // { inherit pkgs; inherit arch; };
      condense = import ./condense.nix params;
      role = import ./basis/role.nix { inherit pkgs; };

      names = (nixpkgs.lib.lists.forEach drops (drop: drop.name));

      drops = [
        (condense "a" {
          roles.root = (role "root" {} {});
        })

        (condense "neo4j" (import ./drop/neo4j.nix
          { inherit pkgs; addr = "10.0.0.10"; }
        ))

        (condense "pod" (import ./drop/pod.nix
          { inherit pkgs; addr = "10.0.0.9"; }
        ))
      ];

      dropped = builtins.listToAttrs drops;

    in {
      channel = signal: sources: import ./channel.nix ({ inherit microvm; } // sources) signal;

      packages = nixpkgs.lib.mergeAttrs
        { nixosConfigurations = dropped; }
        (nixpkgs.lib.attrsets.genAttrs names
        (name: self.packages.${arch}.nixosConfigurations.${name}.config.microvm.declaredRunner));
    });
}
