{ pkgs, ...}@call:
let
  role = import ../basis/role.nix call;
in {
  users.users = { root = role "root" {}; };

  imports = [
    ../module/psql.nix

    ( import ../module/elixir.nix {
      base = "op"; name = "op"; channel = 4000;
      user = "root"; codebase = "/root/share/gram/op";
    })
  ];

  environment.systemPackages = with pkgs; [ isd helix
    elixir nodejs yarn git libgit2 gnupg openssl inotify-tools nushell
  ];
  networking.firewall.allowedTCPPorts = [ 4000 5173 ];

  microvm.shares = [
    { proto = "9p"; tag = "share"; source = "/root/share"; mountPoint = "/root/share"; }
    { proto = "9p"; tag = "unshare"; source = "/root/unshare"; mountPoint = "/root/unshare"; }
  ];
}
