{ pkgs, addr, plug, ...}:
let
  role = import ../basis/role.nix { inherit pkgs; };
  address = import ../basis/address.nix { inherit pkgs; } plug;
in {
  roles = {
    root = role "root" {} {};
    neo4j = (role "neo4j" {
      groups = [ "wheel" ];
      pass = "abcd1234";
    } {});
  };

  module = {
    environment.systemPackages = with pkgs; [ neo4j isd ];
    networking.firewall.allowedTCPPorts = [ 7474 7687 ];
    services.neo4j = {
      enable = true;
      https.enable = false;
      http.enable = true;
      bolt.tlsLevel = "DISABLED";
      defaultListenAddress = "0.0.0.0";
      # extraServerConfig = ''
      # # see https://neo4j.com/docs/operations-manual/current/reference/configuration-settings/
      # '';
    };
    imports = [(address addr)];
  };
}
