{ pkgs, addr, ...}:
let
  role = import ../basis/role.nix { inherit pkgs; };
  address = import ../basis/address.nix { inherit pkgs; };
  loc = "/opt/stacks";
  engine = "podman";

  # dockge = pkgs.dockerTools.pullImage{
  #   imageName = "louislam/dockge";
  #   finalImageTag = "1";
  #   imageDigest = "sha256:632268d5fd9ca87169c65353db99be8b4e2eb41833b626e09688f484222e860f";
  #   sha256 = "1x00ks05cz89k3wc460i03iyyjr7wlr28krk7znavfy2qx5a0hfd";
  # };

in {
  roles = {
    root = role "root" {} {};
    # pod = (role "pod" {
    #   groups = [ "wheel" ];
    #   pass = "abcd1234";
    # } {});
  };

  module = {
    imports = [(address addr)];
    environment.systemPackages = with pkgs; [ isd podman-tui ];

    networking.firewall.allowedTCPPorts = [ 5001 ];

    # virtualisation.${engine}.enable = true;
    virtualisation.podman = {
      enable = true;
      dockerCompat = true;
      dockerSocket.enable = true;
      defaultNetwork.settings.dns_enabled = true;
    };

    virtualisation.oci-containers.backend = engine;
    virtualisation.oci-containers.containers = {
      dockge = {
        autoStart = true;
        image = "docker.io/louislam/dockge:1";
        ports = [
          "${addr}:5001:5001"
          # "5001:5001"
        ];
        environment.DOCKGE_STACKS_DIR = loc;
        volumes = [ "${loc}:${loc}" "./data:/app/data"
          "/var/run/podman/podman.sock:/var/run/docker.sock"
          # "/var/run/docker.sock:/var/run/docker.sock"
        ];
      };
    };
  };
}
