{ inputs = {
    nixpkgs.url = "github:nixos/nixpkgs/nixos-25.11";
    flake-utils.url = "github:numtide/flake-utils";
  };

  outputs = { nixpkgs, flake-utils, ... }:
  flake-utils.lib.eachDefaultSystem (arch: let
    pkgs = import nixpkgs { system = arch; };
  in with pkgs; {
    packages = { default = elixir; };
    devShells.default = mkShell { packages = [ elixir inotify-tools ]; };
  });
}
